#ifndef _DX_VOS_THREAD_STORAGE_H
#define _DX_VOS_THREAD_STORAGE_H

#include "DX_VOS_BaseTypes.h"

#ifdef __cplusplus
extern "C" {
#endif

/*! \file DX_VOS_ThreadStorage.h
This module provide utilities for saving & retrieval of data to & from thread context.
Example:
    DxVosThreadStorage ThreadName;

    void Thread1()
    {
        DxChar* threadName = DX_NULL;
        DX_VOS_ThreadStoragePut(ThreadName, "Thread1");
        threadName = (DxChar*) DX_VOS_ThreadStorageGet(ThreadName);
        DX_VOS_PrintString(threadName); // Prints "Thread1"
    }

    void Thread2()
    {
    DxChar* threadName = DX_NULL;
    DX_VOS_ThreadStoragePut(ThreadName, "Thread2");
    threadName = (DxChar*) DX_VOS_ThreadStorageGet(ThreadName);
    DX_VOS_PrintString(threadName); // Prints "Thread2"
    }

    void Main()
    {
        DX_VOS_ThreadStorageInit(ThreadName);
        // Create Thread1
        // Create Thread2
    }
*/

typedef void* DxVosThreadStorage[DX_VOS_THREAD_RESOLUTION];

/* Initializes the thread storage */
void DX_VOS_ThreadStorageInit(DxVosThreadStorage threadStorage);

/* Saves the specified data in the thread's context */
void DX_VOS_ThreadStoragePut(DxVosThreadStorage threadStorage, void* data);

/* Retrieves the data that is stored in the thread's context */
void* DX_VOS_ThreadStorageGet(DxVosThreadStorage threadStorage);
#ifdef __cplusplus
}
#endif

#endif
